#include <p30fxxxx.h>
#include "incap.h"

/********************************************************************
*    Function Name:  CloseCapture1                                  *
*    Description:    This routine disable the inputcapture and its  *
*                    interrupt bits.                                *
*    Parameters:     None                                           *
*    Return Value:   None                                           *
********************************************************************/
void CloseCapture1()
{
    IEC0bits.IC1IE = 0; /* disable the interrupt flag */
    IC1CONbits.ICM = 0; /* Input Capture x(ic_no) Off */
    IFS0bits.IC1IF = 0; /* disable the interrupt flag */
}

/********************************************************************
*    Function Name:  ConfigIntCapture1                              *
*    Description:    Set the Enable Interrupts and Interrupt        *
*                    Priorites  to the Interrupt Control and        *
*                    Interrupt Priority Register respectively       *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/
void ConfigIntCapture1(unsigned int config)
{
    IFS0bits.IC1IF = 0;                    /* Clear IF bit */
    IPC0bits.IC1IP = (config &0x0007);     /*assigning Interrupt Priority
                                                    to IPC Register */
    IEC0bits.IC1IE = (config &0x0008) >> 3;/*assiging Interrupt Enable/
                                                        Disable.   */   
}

/********************************************************************
*    Function Name:  OpenCapture1                                   *
*    Description:    This routine include configuring clock ,       *
*                    number of capture per interrupt ,capture mode  *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void OpenCapture1(unsigned int config)
{
    /* Config contains Clock source, number of Captures per interuppt
                                    and Capture Mode */
    IC1CON = config;  
}

/********************************************************************
*    Function Name:  ReadCapture1                                   *
*    Description:    This routine reads all pending InputCapture    *
*                    Buffers and stores in the locations specified  *
*    Parameters:     address of locations where buffer data to be   *
*                    stored                                         *
*    Return Value:   None                                           *
********************************************************************/

void ReadCapture1(unsigned int * buffer)
{
	while (IC1CONbits.ICBNE)
	{
		*buffer++ = IC1BUF; /* reads the input capture buffer */
	}
}

/********************************************************************
*    Function Name:  CloseCapture2                                  *
*    Description:    This routine disable the inputcapture and its  *
*                    interrupt bits.                                *
*    Parameters:     None                                           *
*    Return Value:   None                                           *
********************************************************************/

void CloseCapture2()
{
    IEC0bits.IC2IE = 0; /* disable the interrupt */
    IC2CONbits.ICM = 0; /* Input Capture x(ic_no) Off */
    IFS0bits.IC2IF = 0; /* disable the interrupt flag */
}

/********************************************************************
*    Function Name:  ConfigIntCapture2                              *
*    Description:    Set the Enable Interrupts and Interrupt        *
*                    Priorites  to the Interrupt Control and        *
*                    Interrupt Priority Register respectively       *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void ConfigIntCapture2(unsigned int config)
{
    IFS0bits.IC2IF = 0;                     /* Clear IF bit */
    IPC1bits.IC2IP = (config &0x0007);      /* assigning Interrupt Priority
                                             to IPC Control REgister */
    IEC0bits.IC2IE = (config &0x0008) >> 3; /* assiging InputCapture Enable/
                                              Disable bit of IEC Register*/
}

/********************************************************************
*    Function Name:  OpenCapture2                                   *
*    Description:    This routine include configuring clock ,       *
*                    number of capture per interrupt ,capture mode  *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void OpenCapture2(unsigned int config)
{
    /* Config contains Clock source, number of Captures per interuppt
                                    and Capture Mode */
    IC2CON = config;  
}

/********************************************************************
*    Function Name:  ReadCapture2                                   *
*    Description:    This routine reads all pending InputCapture    *
*                    Buffers and stores in the locations specified  *
*    Parameters:     address of locations where buffer data to be   *
*                    stored                                         *
*    Return Value:   None                                           *
********************************************************************/

void ReadCapture2(unsigned int * buffer)
{
	while (IC2CONbits.ICBNE)
	{
		*buffer++ = IC2BUF; /* reads the input capture buffer */
	}
}

/* These devices support Input Capture 3 thru Input Capture 6 */
#if defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__) || \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__)

/********************************************************************
*    Function Name:  CloseCapture3                                  *
*    Description:    This routine disable the inputcapture and its  *
*                    interrupt bits.                                *
*    Parameters:     None                                           *
*    Return Value:   None                                           *
********************************************************************/

void CloseCapture3()
{
    IEC1bits.IC3IE = 0; /* disable the interrupt */
    IC3CONbits.ICM = 0; /* Input Capture x(ic_no) Off */
    IFS1bits.IC3IF = 0; /* disable the interrupt flag */
}

/********************************************************************
*    Function Name:  CloseCapture4                                  *
*    Description:    This routine disable the inputcapture and its  *
*                    interrupt bits.                                *
*    Parameters:     None                                           *
*    Return Value:   None                                           *
********************************************************************/

void CloseCapture4()
{
    IEC1bits.IC4IE = 0; /* disable the interrupt */
    IC4CONbits.ICM = 0; /* Input Capture x(ic_no) Off */
    IFS1bits.IC4IF = 0; /* disable the interrupt flag */
}
/********************************************************************
*    Function Name:  CloseCapture5                                  *
*    Description:    This routine disable the inputcapture and its  *
*                    interrupt bits.                                *
*    Parameters:     None                                           *
*    Return Value:   None                                           *
********************************************************************/

void CloseCapture5()
{
    IEC1bits.IC5IE = 0; /* disable the interrupt */
    IC5CONbits.ICM = 0; /* Input Capture x(ic_no) Off */
    IFS1bits.IC5IF = 0; /* disable the interrupt flag */
}

/********************************************************************
*    Function Name:  CloseCapture6                                  *
*    Description:    This routine disable the inputcapture and its  *
*                    interrupt bits.                                *
*    Parameters:     None                                           *
*    Return Value:   None                                           *
********************************************************************/

void CloseCapture6()
{
    IEC1bits.IC6IE = 0; /* disable the interrupt */
    IC6CONbits.ICM = 0; /* Input Capture x(ic_no) Off */
    IFS1bits.IC6IF = 0; /* disable the interrupt flag */
}
/********************************************************************
*    Function Name:  ConfigIntCapture3                              *
*    Description:    Set the Enable Interrupts and Interrupt        *
*                    Priorites  to the Interrupt Control and        *
*                    Interrupt Priority Register respectively       *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void ConfigIntCapture3(unsigned int config)
{
    IFS1bits.IC3IF = 0;                   /* Clear IF bit */
    IPC7bits.IC3IP = (config &0x0007);    /* assigning Interrupt Priority 
                                             to IPC Register              */
    IEC1bits.IC3IE = (config &0x0008) >> 3;/* assiging Interrupt Enable/
                                              Disable to IEC Register    */
}
/********************************************************************
*    Function Name:  ConfigIntCapture4                              *
*    Description:    Set the Enable Interrupts and Interrupt        *
*                    Priorites  to the Interrupt Control and        *
*                    Interrupt Priority Register respectively       *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void ConfigIntCapture4(unsigned int config)
{
    IFS1bits.IC4IF = 0;                   /* Clear IF bit */
    IPC7bits.IC4IP = (config &0x0007);    /* assigning Interrupt Priority
                                             to IPC Register             */
    IEC1bits.IC4IE = (config &0x0008) >> 3;/* assiging Interrupt Enable/
                                              Disable Register           */
}
/********************************************************************
*    Function Name:  ConfigIntCapture5                              *
*    Description:    Set the Enable Interrupts and Interrupt        *
*                    Priorites  to the Interrupt Control and        *
*                    Interrupt Priority Register respectively       *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void ConfigIntCapture5(unsigned int config)
{
    IFS1bits.IC5IF = 0;                       /* Clear IF bit */
    IPC7bits.IC5IP = (config &0x0007);        /* assigning Interrupt Priority 
                                                           to IPC */
    IEC1bits.IC5IE = (config &0x0008) >> 3;   /* assign Interrupt Enable/
                                                      Disable     */
    
}
/********************************************************************
*    Function Name:  ConfigIntCapture6                              *
*    Description:    Set the Enable Interrupts and Interrupt        *
*                    Priorites  to the Interrupt Control and        *
*                    Interrupt Priority Register respectively       *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void ConfigIntCapture6(unsigned int config)
{
    IFS1bits.IC6IF = 0;                     /* Clear IF bit */
    IPC7bits.IC6IP = (config & 0x0007);     /* assigning Interrupt Priority 
                                                            to IPC */
    IEC1bits.IC6IE = (config & 0x0008)>>3;  /* assiging Interrupt Enable/
                                                           Disable */
}
/********************************************************************
*    Function Name:  OpenCapture3                                   *
*    Description:    This routine include configuring clock ,       *
*                    number of capture per interrupt ,capture mode  *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void OpenCapture3(unsigned int config)
{
    /* Config contains Clock source, number of Captures per interuppt
                                    and Capture Mode */
    IC3CON = config;  
}
/********************************************************************
*    Function Name:  OpenCapture4                                   *
*    Description:    This routine include configuring clock ,       *
*                    number of capture per interrupt ,capture mode  *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void OpenCapture4( unsigned int config)
{
    /* Config contains Clock source, number of Captures per interuppt
                                    and Capture Mode */
    IC4CON = config;  
}

/********************************************************************
*    Function Name:  OpenCapture5                                   *
*    Description:    This routine include configuring clock ,       *
*                    number of capture per interrupt ,capture mode  *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void OpenCapture5(unsigned int config)
{
    /* Config contains Clock source, number of Captures per interuppt
                                    and Capture Mode */
    IC5CON = config;  
}
/********************************************************************
*    Function Name:  OpenCapture6                                   *
*    Description:    This routine include configuring clock ,       *
*                    number of capture per interrupt ,capture mode  *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void OpenCapture6( unsigned int config)
{
    /* Config contains Clock source, number of Captures per interuppt
                                    and Capture Mode */
    IC6CON = config;  
}

/********************************************************************
*    Function Name:  ReadCapture3                                   *
*    Description:    This routine reads all pending InputCapture    *
*                    Buffers and stores in the locations specified  *
*    Parameters:     address of locations where buffer data to be   *
*                    stored                                         *
*    Return Value:   None                                           *
********************************************************************/

void ReadCapture3(unsigned int * buffer)
{
	while (IC3CONbits.ICBNE)
	{
		*buffer++ = IC3BUF; /* reads the input capture buffer */
	}
}
/********************************************************************
*    Function Name:  ReadCapture4                                   *
*    Description:    This routine reads all pending InputCapture    *
*                    Buffers and stores in the locations specified  *
*    Parameters:     address of locations where buffer data to be   *
*                    stored                                         *
*    Return Value:   None                                           *
********************************************************************/

void ReadCapture4(unsigned int * buffer)
{
	while (IC4CONbits.ICBNE)
	{
		*buffer++ = IC4BUF; /* reads the input capture buffer */
	}
}

/********************************************************************
*    Function Name:  ReadCapture5                                   *
*    Description:    This routine reads all pending InputCapture    *
*                    Buffers and stores in the locations specified  *
*    Parameters:     address of locations where buffer data to be   *
*                    stored                                         *
*    Return Value:   None                                           *
********************************************************************/

void ReadCapture5(unsigned int * buffer)
{
	while (IC5CONbits.ICBNE)
	{
		*buffer++ = IC5BUF; /* reads the input capture buffer */
	}
}
/********************************************************************
*    Function Name:  ReadCapture6                                   *
*    Description:    This routine reads all pending InputCapture    *
*                    Buffers and stores in the locations specified  *
*    Parameters:     address of locations where buffer data to be   *
*                    stored                                         *
*    Return Value:   None                                           *
********************************************************************/

void ReadCapture6(unsigned int * buffer)
{
	while (IC6CONbits.ICBNE)
	{
		*buffer++ = IC6BUF; /* reads the input capture buffer */
	}
}

#endif

/* These devices support Input Capture 7 and Input Capture 8 */
#if defined (__dsPIC30F2010__) || defined (__dsPIC30F3010__) || defined (__dsPIC30F4012__) || \
    defined (__dsPIC30F3011__) || defined (__dsPIC30F4011__) || defined (__dsPIC30F6010__) || \
    defined (__dsPIC30F5011__) || defined (__dsPIC30F6011__) || defined (__dsPIC30F6012__) || \
    defined (__dsPIC30F5013__) || defined (__dsPIC30F6013__) || defined (__dsPIC30F6014__) || \
    defined (__dsPIC30F4013__) || defined (__dsPIC30F5015__)

/********************************************************************
*    Function Name:  CloseCapture7                                  *
*    Description:    This routine disable the inputcapture and its  *
*                    interrupt bits.                                *
*    Parameters:     None                                           *
*    Return Value:   None                                           *
********************************************************************/

void CloseCapture7()
{
    IEC1bits.IC7IE = 0; /* disable the interrupt flag */
    IC7CONbits.ICM = 0; /* Input Capture x(ic_no) Off */
    IFS1bits.IC7IF = 0; /* disable the interrupt flag */
}
/********************************************************************
*    Function Name:  CloseCapture8                                  *
*    Description:    This routine disable the inputcapture and its  *
*                    interrupt bits.                                *
*    Parameters:     None                                           *
*    Return Value:   None                                           *
********************************************************************/

void CloseCapture8()
{
    IEC1bits.IC8IE = 0; /* disable the interrupt */
    IC8CONbits.ICM = 0; /* Input Capture x(ic_no) Off */
    IFS1bits.IC8IF = 0; /* disable the interrupt flag */
}
/********************************************************************
*    Function Name:  ConfigIntCapture7                              *
*    Description:    Set the Enable Interrupts and Interrupt        *
*                    Priorites  to the Interrupt Control and        *
*                    Interrupt Priority Register respectively       *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void ConfigIntCapture7(unsigned int config)
{
    IFS1bits.IC7IF = 0;                    /* Clear IF bit */
    IPC4bits.IC7IP = (config & 0x0007);    /*assigning Interrupt Priority
                                                              to IPC*/
    IEC1bits.IC7IE = (config & 0x0008)>>3; /*assigns Interrupt Enable/
                                                            Disable */
}
/********************************************************************
*    Function Name:  ConfigIntCapture8                              *
*    Description:    Set the Enable Interrupts and Interrupt        *
*                    Priorites  to the Interrupt Control and        *
*                    Interrupt Priority Register respectively       *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void ConfigIntCapture8(unsigned int config)
{
    IFS1bits.IC8IF = 0;                    /* Clear IF bit */
    IPC4bits.IC8IP = (config & 0x0007);    /*assigning Interrupt  Priority
                                                              to IPC*/
    IEC1bits.IC8IE = (config & 0x0008)>>3; /*assign Interrupt Enable/
                                                            Disable */
}
/********************************************************************
*    Function Name:  OpenCapture7                                   *
*    Description:    This routine include configuring clock ,       *
*                    number of capture per interrupt ,capture mode  *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void OpenCapture7(unsigned int config)
{
    /* Config contains Clock source, number of Captures per interuppt
                                    and Capture Mode */
    IC7CON = config;  
}

/********************************************************************
*    Function Name:  OpenCapture8                                   *
*    Description:    This routine include configuring clock ,       *
*                    number of capture per interrupt ,capture mode  *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void OpenCapture8( unsigned int config)
{
    /* Config contains Clock source, number of Captures per interuppt
                                    and Capture Mode */
    IC8CON = config;  
}

/********************************************************************
*    Function Name:  ReadCapture7                                   *
*    Description:    This routine reads all pending InputCapture    *
*                    Buffers and stores in the locations specified  *
*    Parameters:     address of locations where buffer data to be   *
*                    stored                                         *
*    Return Value:   None                                           *
********************************************************************/

void ReadCapture7(unsigned int * buffer)
{
	while (IC7CONbits.ICBNE)
	{
		*buffer++ = IC7BUF; /* reads the input capture buffer */
	}
}
/********************************************************************
*    Function Name:  ReadCapture8                                   *
*    Description:    This routine reads all pending InputCapture    *
*                    Buffers and stores in the locations specified  *
*    Parameters:     address of locations where buffer data to be   *
*                    stored                                         *
*    Return Value:   None                                           *
********************************************************************/

void ReadCapture8(unsigned int * buffer)
{
	while (IC8CONbits.ICBNE)
	{
		*buffer++ = IC8BUF; /* reads the input capture buffer */
	}
}

#endif




